/*
 * A vector quantizer for texture compression
 *
 * Copyright (c) 2012 Jens Ogniewski, Information Coding Group,
 *                    Linköpings University, Sweden
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// inputs:
// in: the image in RGBA order
// width: width of the image
// height: height of the image
// use_yuv_weight: do the search in yuv-space, giving the luminance component a higher weight (<=0 to decativate, >0 to activate)
// do_refinment: include the search for the local optimum (<=0 to decativate, >0 to activate)
// deblock: use deblocking (use pixels from adjacent blocks during the search); set to 0 to activate; >0: number of adjacents pixels
// wraparound: set to >0 to use wrap-around for deblocking filter
//
// outputs:
// min_out, max_out: maps of the two different vectors of each blocks, in RGBA.
//                   Note that the alpha channel is not supported (yet).
// modsel: the indices of the pixels
//
// returns:
// Nothing. May print out error messages.

void vector_quantization(unsigned char *in, unsigned int width, unsigned int height, unsigned char **min_out, unsigned char **max_out, unsigned char **colsel, int use_yuv_weight, int do_refinement, int deblock, int wraparound);

// inputs:
// min_out, max_out: maps of the two different vectors of each blocks, in RGBA.
//                   Note that the alpha channel is not supported (yet).
// modsel: the indices of the pixels
// width:  the width of the decoded image
// height: the height of the decoded image
//
// outputs:
// decoded_image: the decoded image
//
// returns:
// Nothing. May print out error messages.

void vector_quantization_decode(unsigned char *min, unsigned char *max, unsigned char *colsel, unsigned int width, unsigned int height, unsigned char **decoded_image);
