/*
 * A no-frills tool for writing bmp images 
 *
 * Copyright (c) 2010 Jens Ogniewski, Information Coding Group,
 *                    Linköpings University, Sweden
 *
 * The function(s) in this file is/are free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public  License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include "bmp_writer.h"

int write_bmp_image(const char* name, const unsigned char *img_data, const unsigned int width, const unsigned int height) {
  unsigned int g,h;
  FILE *fo;
  unsigned int il=4*width*height;
  unsigned int fl=54+4*width*height;
  unsigned char *f=(unsigned char*)malloc(fl);
  if (!f) {
    printf("\nbmp_writer: Allocating memory for file %s failed!\n\n",name);
    return -1;
  }

  //magic number
  f[0] =0x42;
  f[1] =0x4D;
  //file length
  f[2] =fl&0xff;
  f[3] =(fl>>8)&0xff;
  f[4] =(fl>>16)&0xff;
  f[5] =(fl>>24)&0xff;
  //unused
  f[6] =0x00;
  f[7] =0x00;    
  f[8] =0x00;
  f[9] =0x00;
  //offset    
  f[10]=0x36;
  f[11]=0x00;    
  f[12]=0x00;
  f[13]=0x00;
  //DIB header length
  f[14]=0x28;
  f[15]=0x00;    
  f[16]=0x00;
  f[17]=0x00;
  //image width
  f[18]=width&0xff;
  f[19]=(width>>8)&0xff;
  f[20]=(width>>16)&0xff;
  f[21]=(width>>24)&0xff;
  //image height
  f[22]=height&0xff;
  f[23]=(height>>8)&0xff;
  f[24]=(height>>16)&0xff;
  f[25]=(height>>24)&0xff;
  //planes
  f[26]=0x01;
  f[27]=0x00;
  //bpp
  f[28]=0x20;
  f[29]=0x00;
  //compression
  f[30]=0x00;
  f[31]=0x00;
  f[32]=0x00;
  f[33]=0x00;
  //image size in bytes
  f[34]=il&0xff;
  f[35]=(il>>8)&0xff;
  f[36]=(il>>16)&0xff;
  f[37]=(il>>24)&0xff;
  //resolution
  f[38]=0x13;
  f[39]=0x0b;
  f[40]=0x00;
  f[41]=0x00;
  f[42]=0x13;
  f[43]=0x0b;
  f[44]=0x00;
  f[45]=0x00;
  //palette
  f[46]=0x00;
  f[47]=0x00;    
  f[48]=0x00;
  f[49]=0x00;
  //important colors
  f[50]=0x00;
  f[51]=0x00;    
  f[52]=0x00;
  f[53]=0x00;
  for (g=0;g<height;g++) {
    for (h=0;h<width;h++) {
      f[(g*width+h)*4+54]=img_data[((height-1-g)*width+h)*4+2];
      f[(g*width+h)*4+55]=img_data[((height-1-g)*width+h)*4+1];
      f[(g*width+h)*4+56]=img_data[((height-1-g)*width+h)*4];
      f[(g*width+h)*4+57]=img_data[((height-1-g)*width+h)*4+3];
    }
  }

  fo = fopen(name, "w");
  if (!fo) {
    printf("\nbmp_writer: Opening of file %s failed!\n\n",name);
    return -1;
  }
  
  if (!fwrite(f, 1, fl, fo)) {
    printf("\nbmp_writer: Writing to file %s failed!\n\n",name);
    fclose(fo);
    return -1;
  }

  fclose(fo);
  free(f);

  return 0;
}
