function [ctr,dir,dims,s]= computing_centers_and_bases(data,inds,dims)

%The data must be passed in as Observations x dimensions (NxD)


K = max(inds);

if length(dims) == 1 && K>1
    dims = dims*ones(K,1);
end

% intialization
ctr = cell(K,1);
dir = cell(K,1);
s =  cell(K,1);

for k = 1:K
    
    cls_k = data((inds==k),:);
    n_k = size(cls_k,1);

    if n_k >= dims(k)+1
       
       ctr{k,1} = mean(cls_k,1);
       cls_k = bsxfun(@minus,cls_k,ctr{k,1});
%        cls_k = cls_k - repmat(ctr{k,1},n_k,1);
       [~,sk,vk] = svd(cls_k,0);
    
       dir{k,1} = vk(:,1:dims(k))';
       s{k,1}=  diag(sk(1:dims(k),1:dims(k)));
       
    end

end
