%Re write of Chen et al function


%Output: 
%mse= mean OLS distance (averaged over number of subspaces)
%Ds = a Kx1 vector of the OLS distances of every subspace from its constituent points

function [mse,Ds] = OLS_error(data, dim, idx, ctr, dir)

N = size(data,1);

K = max(idx);

if isempty(dim)
    dim = estimate_intrinsic_dimensions(data, idx); %TODO
elseif length(dim) < K
    dim = dim(end)*ones(K,1);
end

if nargin<4
    [ctr,dir] = computing_centers_and_bases(data,idx,dim);
end



mse = 0; Ds=zeros(K,1);
for k = 1:K
%     index=find(idx==k);
    cls_k = data(idx==k,:);
    n_k = size(cls_k,1);
    if n_k > dim(k)
        cls_k = bsxfun(@minus,cls_k,ctr{k,1});
%         cls_k = cls_k - repmat(ctr{k,1},n_k,1);
        OLSerrs=sum(cls_k.^2,2) - sum((cls_k*dir{k,1}').^2,2);
             
        mse = mse + sum(OLSerrs);
        
    end
    
    Ds(k)=mse;
end
 
mse = sqrt(mse/N);



