%Orthogonal Least Squares fitting error affinity (type 2) between two clusters (data1, and data2).
%This is using the "mutual projection" approach. That is, fit a hyperplane to each cluster individually and then do the 
%mutual projection of the cluster points to the opposite hyperplane and calculate the error

%Note that this is NOT a symmetric affinity.

function [a,a12,a21]=OLS_affinity_type2(data1,data2,dim1,ctr1,dir1, dim2,ctr2,dir2)

N1=size(data1,2);
N2=size(data2,2);

% inds1=ones(N1,1);
% inds2=ones(N2,1);




%% MUTUAL PROJECTION

% % tic
% 
% %OLS(F1,C2). Project cluster 2 onto plane fitted from cluster 1
% a12 = real(OLS_error(data2', dim1, inds2,ctr1, dir1));
% 
% %OLS(F2,C1). Project cluster 1 onto plane fitted from cluster 2
% a21 = real(OLS_error(data1', dim2, inds1, ctr2, dir2));
% 
% % toc
% 
% % make symmetric
% a= (a12+a21)/2;
% % a=max(a12,a21);
% % a=sqrt(a12*a21);

% tic
points = bsxfun(@minus,data2',ctr1{1});
a12_ =  abs(sqrt(sum(sum(points.^2,2) - sum((points*dir1{1}').^2,2))/N2)); %absolute to avoid any numerical problems

points = bsxfun(@minus,data1',ctr2{1});
a21_ = abs(sqrt(sum(sum(points.^2,2) - sum((points*dir2{1}').^2,2))/N1));%absolute to avoid any numerical problems 

% toc

a= (a12_+a21_)/2;


% tic
% 
% points = data2' - repmat(ctr1{1},N2,1); 
% a12__ =  sum(sum(points.^2,2) - sum((points*dir1{1}').^2,2));
% 
% points = data1' - repmat(ctr2{1},N1,1); 
% a21__ = sum(sum(points.^2,2) - sum((points*dir2{1}').^2,2));
% 
% toc
% 
% a__= (a12__+a21__)/2;
% 
% 
% a12
% a21
% a
% a12_
% a21_
% a_
% a12__
% a21__
% a__
