function clusterid=HBGF_spectral(ceresults,idxs,  k,W,lambda,C)

%C=NxN constraint matrix
%W= weight vector


% clusterid=HBGF_spec(ceresults, idxs,  k)
% ceresults: contains a library of clustering solutions, each column is one solution.
% idxs: contains the indexs of the solutions that are included in the ensemble.
% If you want to use all the solutions in ceresults, set idxs = length(ceresults, 2)
% k: the number of clusters for the final clustering
%
%
%"Solving cluster ensemble problems by bipartite graph partitioning", in
%Proceedings of 21th International Conference on Machine learning (ICML2004)


sresults = ceresults(:, idxs);
esize = length(idxs);
instnum = size(ceresults,1);
% form the connectivity matrix instnum X totalk
w=formw(sresults, esize, instnum);

% compute the size of each cluster
csize=sum(w);



% normalize the vectors
w = w*diag(1./sqrt(csize));


% assign weights to each clustering (not each cluster)
if exist('W','var')
    counter=1;
    for i=1:k:size(w,2)
        try
             w(:,i:i+k-1)=w(:,i:i+k-1)*exp(-W(counter)./lambda);            
        end
        counter=counter+1;
    end
end




%Global parameter search
iQual=inf;  
for sigmas=2:8
 
    A=abs(w*w').^sigmas;    A=A./max(A(:));   A=A-diag(diag(A));
 
    try
        if exist('C','var')
            
            [testI,qual]=ConstrainedSpectralClustering(A,C,0.9,k); %constrained spectral clustering
        else
            [testI,qual]=spectral_clustering(A,k); %standard spectral clustering
        end
        
        if qual<iQual
            clusterid=testI;
            iQual=qual;
        end
        
    catch
        fprintf('Eigen decomp. failed. Try a larger lambda \n');
    end
    
    
end




     
function w=formw(idxs, r, instnum)
% this function turns a cluster ensemble into a set of new binary features, one for each cluster
% if the object belongs to that cluster, the value is set to 1, and 0 otherwise
site=1;
for i=1:r
    idx = idxs(:,i);
    uniqueks=unique(idx(idx>0)); % 0 is considered to be the unclustered
    t=zeros(instnum, length(uniqueks));
    t(find(repmat(idx, 1, length(uniqueks)) == repmat(uniqueks', instnum, 1)))=1;
    w(:, site:site+length(uniqueks)-1) = t;
    site=site+length(uniqueks);
end

