function [I,Is,ProjectionMatrix]=DiSC(W,dim,final_clusters,classf,lambda,Ensembles)

if ~exist('lambda','var')
   lambda=0.01;
end

lambda_0=lambda;
    
K=min(final_clusters*dim,size(W,1));



dim=min(K,dim);

N=size(W,2);
if ~exist('Ensembles','var'), Ensembles=50; end

PPCluster=dim+3;
Clusters=max(10,floor(N*0.1)); %number of clusters




% Is=[]; Weights=[];

Is=ones(size(W,2),Ensembles)*-1;  	% To parallelize loop
Weights=zeros(1,Ensembles);         % To parallelize loop
lambda=ones(1,Ensembles)*lambda;    % To parallelize loop
I_CL=cell(N,Ensembles); ProjectionMatrix=cell(Ensembles,1);

parfor iter=1:Ensembles
    
    %do a new random projection at every iteration
    [X,ProjMat] = DataProjection(W,K,'NormalProj');
    ProjectionMatrix{iter,1}= ProjMat
    X=[X; ones(1,size(X,2))]; %set to homogeneous coordinates.
    
    
    
    %% Initialise clusters
    [clusters,cl_size]=initialise(X',1,Clusters,PPCluster,size(X,2),'other');
    CL=cell2mat(clusters);
    
    
    
    
    
    %% Pre-calculate subspace fits using PCA
    inds=[];
    for idx=1:cl_size
        inds=[inds; idx*ones(PPCluster,1)];
    end
    
    
    [ctr,dir,dims,~]= computing_centers_and_bases(X(:,CL)',inds,dim);

    
    
    %% Calculate pair-wise mutual projection affinities
    OLSErr=zeros(cl_size,cl_size);
    for i=1:cl_size-1
        for j=i+1:cl_size
            OLSErr(i,j)=OLS_affinity_type2(X(:,CL(:,i)),X(:,CL(:,j)),dims(i),ctr(i),dir(i),dims(j),ctr(j),dir(j));
        end
    end
    OLSErr = OLSErr + tril(OLSErr.',-1);
    Z=OLSErr; 
    Z=Z/max(Z(:));
        
    
    %% MERGE the clusters
    while 1
      Aff= exp(-Z./lambda(iter)); %exponential kernel  
 
 
        Aff=Aff-diag(diag(Aff));
        
        try  
            I_CL{iter}=spectral_clustering(Aff,final_clusters);  
            break;
        catch
            fprintf('SC failed. Trying again with a larger lambda \n');
            lambda(iter)=lambda(iter)+0.001; %add a small increment and retry
        end
    end
    

    


    
    %% Classifier.
    %if we have overlapping clusters then we OVERTRAIN WITH DUPLICATE POINTS.
    priors=[]; C=[]; labels=[];
    
    
    
    for cl=1:cl_size
        C=[C, X(1:end-1,CL(:,cl))]; %dim reduced
        labels=[labels; I_CL{iter}(cl)*ones(PPCluster,1)];
    end
    
    
    %REMOVE DUPLICATE POINTS
    [B,In]=unique(C','rows'); C=B';
    labels=labels(In);
    
    
    
    for kkk=1:final_clusters
        indx=find(labels==kkk);
        priors=[priors, numel(indx)/length(labels)];
    end
    [labels,cardinality]=flatenMatrix(labels);
    
    
    
    
    %Ignore clusterings with fewer classes they should be (i.e. empty clusters)
    %and clusters with fewer points than the minimum required PPCluster
    if cardinality==final_clusters &&  sum(priors<PPCluster/length(labels))==0
        
        A=dataset(C',labels); %remove the homogeneous coordinate  


        A.prior=priors; 
        R=10^(-5);
        S=R;
 
        
         w=feval(classf, A,R,S); %the classifier to use
         Itemp=X(1:end-1,:)'*w*labeld; %apply the classifier on test data. But remove the homogeneous coordinate
        
            

                
            degenerateLabelling=0;
            for kkk=1:final_clusters
                if sum(Itemp==kkk)<PPCluster
                    degenerateLabelling=1;
                    break;
                end
            end
            
            if ~degenerateLabelling
                
                %Accept the new labeling
                Is(:,iter)=Itemp;
                
                %% Calculate PER-CLUSTERING weights. Used for the Ensemble clustering
                Weights(iter)=real(OLS_error(X', dim, Is(:,iter))); %OLS fitting error. For all clusters in the clustering
                
           
            end
     
       
      
        
    end
    
end




%Ensemble clustering
I= HBGF_spectral(Is,1:size(Is,2),final_clusters,Weights,lambda_0);




