

function [Xp,ProjMat] = DataProjection(X,r,type)

if r == 0
    Xp = X;
else
    if (nargin < 3)
        type = 'NormalProj';
    end
    D = size(X,1);
    
    if ( strcmp(type , 'PCA') )
        
        mX=mean(X,2);
        X=bsxfun(@minus,X,mX);
        C=cov(X');
        [U,V]=eigs(C,r);
        Xp=U'*X;
        ProjMat=U';
        
    elseif ( strcmp(type , 'NormalProj') )
        
        np = normrnd(0,1/sqrt(r),r*D,1);
        PrN = reshape(np,r,D);
        Xp = PrN * X;
        ProjMat=PrN;
        
    elseif( strcmp(type , 'BernoulliProj') )
        
        bp = rand(r*D,1);
        Bp = 1/sqrt(r) .* (bp >= .5) - 1/sqrt(r) .* (bp < .5);
        PrB = reshape(Bp,r,D);
        Xp = PrB * X;
        ProjMat=PrB;
        
        
        
        %Achlioptas
    elseif( strcmp(type , 'Sparse') )
        
        sp =  randi(6,r*D,1);
        Sp = sqrt(3/r)* ([sp==1] - [ sp==2]);
        
        %avoid all zeros in a row
        num=D; 
        while num==D
         Sp=Sp((randperm(length(Sp))));
         PrS = reshape(Sp,r,D);         
         num=max(sum(PrS==0,2));
        end
        Xp = PrS * X;
        ProjMat=PrS;
        
   
        
        %Random subspace projection. Note, it does not satisfy the JL lemma
    elseif( strcmp(type , 'Subspace') )
        

        PrS = [eye(r) zeros(r,D-r)];
        colI=randperm(D);
        rowI=randperm(r);
        PrS=PrS(rowI,colI);
        Xp = PrS * X;    
        ProjMat=PrS;
        
        
    end
    
    
    %NOTE! Do not normalise for PCA
    %The normalisation is done in order to have affinities between fixed ranges and
    %thus make selection of spectral clustering parameters easier/consistent
    if ( strcmp(type , 'PCA') )
    else
        %normalise (center and scale) the data
        Mx=mean(Xp,2);
        Xp=bsxfun(@minus,Xp,Mx);
        Vr=var(Xp,[],2);
        Xp=bsxfun(@rdivide,Xp,sqrt(Vr));
        
        
    end
end