
function [clusters,clust_size]=initialise(coord,t,clust_size,Npoints,Ntotal,type)
% Initialise only from the t frame of the sequence



if strcmp(type,'kmeans')
    
    %% kmeans initialisation
    kmeans_type='sample'; %choices 'cluster', 'uniform', 'sample'
    min_KMclust_size=1;     %minimum number of points in the K-means clusters
    
    
    %kmeans clustering for initialisation
    [memb,C,~, D] = kmeans(squeeze(coord(1:2,t,:))',clust_size,'EmptyAction','drop','Replicates',10, 'Start', kmeans_type);

    
    %discard clusters with very few points
    idx=[];
    for i=1:clust_size
        if sum(memb==i) < min_KMclust_size
            idx(end+1)=i;
        end
    end
    D(:,idx)=[];
    C(idx,:)=[];
    clust_size=clust_size-length(idx);
    
    
  
    
else
   %% random sample initialisation
   sindx=randsample(Ntotal,clust_size);
   C=squeeze(coord(1:2,t,sindx))';
   D=pdist2(C,squeeze(coord(1:2,t,:))')';
    
end


%take Npoints-closer points to each cluster center
clusters=cell(1,clust_size); %clusters
for i=1:clust_size
    [Dist, DI] =sort(D(:,i));
    clusters{i}=DI(1:Npoints);
end

