L = 0.2; 		% distance source - rot. center
dx0 = 0.00036; 		% detector element size 
dfi0 = 0.74;		% angle increment in degrees
M0 = 256;		% nr of pixels per projection
N0 = 280;		% nr of projections

dx1 = 0.00036;		% new detector element size
dfi1 = 1;		% new angle increment in degrees
M1 = 255;		% new nr of pixels per projection
N1 = 180;		% new nr of projections

gamma = 180*atan(M0/2*dx0/L)/pi;% fanbeam angle
firstang = pi*gamma/180; % first angle after rebinning

x0 = (-M0/2:M0/2-1)*dx0;	% detector axis
a0 = (0:N0-1)*dfi0;		% detector axis

x1 = (-M1/2:M1/2-1)*dx1;	% new detector axis
a1 = (0:N1-1)*dfi1+gamma;	% new detector axis

xvec = (-(M1-1)/2:(M1-1)/2);    % image axis

% ************ mono ****************************
g = take('mono=30');
[N,R,M] = size(g);  % N = nr of pixels per projection
                    % R = nr of rows
                    % M = nr of projections
g = log(max(max(g))) - log(g);
g1 = zeros(N,M);
g1(:,:) = g(:,1,:);

reb = rebinning(g1, L, dx0, dfi0, 1, 0, dx1, dfi1, M1, N1);
fhat0 = parFB(reb, dx1, firstang);  

figure(1);
subplot(2,2,1), imagesc(a0,x0,g1);
colorbar;
title('a) mono fanbeam proj')
subplot(2,2,2), imagesc(a1,x1,reb);
colorbar;
title('b) mono parallel proj')
subplot(2,2,3), imagesc(xvec, xvec, fhat0', [25,35]);
colorbar;
title('c) mono recon')
axis image;

% ************ poly ****************************
g = take;
g = log(max(max(g))) - log(g);
g1 = zeros(N,M);
g1(:,:) = g(:,1,:);

reb = rebinning(g1, L, dx0, dfi0, 1, 0, dx1, dfi1, M1, N1);
fhat = parFB(reb, dx1, firstang);

subplot(2,2,4), imagesc(xvec, xvec, fhat', [25,35]);
colorbar;
title('d) poly recon')
axis image;

figure(2);
subplot(2,2,1), plot(x1, fhat0(128,:), '-r', ...
		     x1, fhat(128,:), '--b');
title('recon cross-sec')
xlabel('x [m]');
ylabel('\mu [m^{-1}]');
axis([-0.05 0.05 -5 40]);
