f = take('mono=30', 'initfile=take1.txt');

sizevol = size(f);
N1 = sizevol(1);                        % N1*N2*N3 = volume size
N2 = sizevol(2);                      
N3 = sizevol(3);                      

rec = 0.6;
vec1 = (-(N1-1)/2:(N1-1)/2)*rec/N1;     % image axis
vec2 = (-(N2-1)/2:(N2-1)/2)*rec/N2;     % image axis
vec3 = (-(N3-1)/2:(N3-1)/2)*rec/N3;     % image axis

f1 = zeros(N1,N2);
f1(:,:) = f(:,:,N3/2);
f3 = zeros(N2,N3);
f3(:,:) = f(N1/2,:,:);
f2 = zeros(N1,N3);
f2(:,:) = f(:,N2/2,:);

figure(1);
colormap(gray);
subplot(2,2,1), imagesc(vec2, vec1, f1');
colorbar;
title('a) voxel-volume xy-slice')
axis image;
subplot(2,2,2), imagesc(vec1, vec3, f2');
colorbar;
title('b) voxel-volume xz-slice')
axis image;
subplot(2,2,3), imagesc(vec2, vec3, f3');
colorbar;
title('c) voxel-volume yz-slice')
axis image;

f = take('mono=30', 'attenuation=takelog','initfile=take2.txt');

sizevol = size(f);
N1 = sizevol(1);                        % N1 = nr of channels
N2 = sizevol(2);                        % N2 = nr of rows
N3 = sizevol(3);                        % N3 = nr of projections

vec1 = (-(N1-1)/2:(N1-1)/2);            % image axes
vec2 = (-(N2-1)/2:(N2-1)/2);            
vec3 = 1:360;                           

f1 = zeros(N1,N2);
f1(:,:) = f(:,:,1);
f2 = zeros(N1,N2);
f2(:,:) = f(:,:,N3/6);
f3 = zeros(N1,N2);
f3(:,:) = f(:,:,N3/4);
f4 = zeros(N1,N3);
f4(:,:) = f(:,(N2+1)/2,:);

figure(2);
colormap(gray);
subplot(2,2,1), imagesc(vec2, vec1, f1');
colorbar;
title('a) detector data 0 deg')
axis image;
subplot(2,2,2), imagesc(vec2, vec1, f2');
colorbar;
title('b) detector data 60 deg')
axis image;
subplot(2,2,3), imagesc(vec2, vec1, f3');
colorbar;
title('c) detector data 90 deg')
axis image;
subplot(2,2,4), imagesc(vec3, vec1, f4);
colorbar;
title('d) 1 row 0-360 deg projdata')


