% Copyright Vasileios Zografos vasileios@zografos.org
% Please cite: V.Zografos et al.  "The Weibull manifold in low-level image processing: An application to automatic image focusing", IMAVIS 31 (5), 2013, pp 401-417



clear all; close all; clc


path='./data/';
t_gt=0.6964; %the ground truth lens position

%% Parameter settings
type = 1; %sharpness function type 0=Weiibull variance, 1=Weibull angle
lensMAX=1;
lensMIN=0;
D=dir([path,'/*.JPG']);
lensMinimumStepsize=1/56;
verbose=1;
% options=optimset('Display','off','TolF',1e-06,'TolX',1e-06);
% f = @(t)SharpnessFunction(t,path,lensMIN,lensMAX,type,[0,0]);


%% TESTS

Fvals=zeros(10,1);
Tvals=zeros(10,1);
Iters=zeros(10,1);
Dist_lens=zeros(10,1);
MotorSteps_from_GT=zeros(10,1);

testRuns=1;

for test=1:testRuns
    
    
    t0= 0.2 + (0.4-0.2).*rand;
    steplength= 0.1 + (0.3-0.1).*rand;
    fprintf('Test run %i, t0= %6.4f, steplength= %6.6f \n',test,t0,steplength);
    
    MotorSteps_gt= floor(abs(t0-t_gt)/lensMinimumStepsize)+floor(t0/lensMinimumStepsize); %ground truth motorstep frames if we were to go from t0 to the solution in one iteration (also the motorsteps from 0 to t0 are included)

    
    
% WEIBULL OPTIMISATION METHOD
[Ts,Errors,iter,MotorSteps1]=WeibullOptimisation(t0,path,lensMIN,lensMAX,lensMinimumStepsize,steplength,type,verbose);



Fvals(test)=Errors(end);  %sharpness function value

Tvals(test)= abs(Ts(end)-t_gt) /lensMinimumStepsize; %lens position distance from ground truth

Iters(test)=iter; %number of iterations

MotorSteps_from_GT(test,:)= [MotorSteps1]-MotorSteps_gt;  %Motorsteps from ground truth


end
 

