function fresult = idfilter(image,windowsize,orbitnumber)
%IDFILTER: fresult = idfilter(image,windowsize,axisnumber)
%   Dihedral filters for the inner points
%
% Version 1.0
% Reiner Lenz
% 26. Oct. 2011

%% nargin = 1,2,3

switch nargin
    case 1
        windowsize = 4;
        orbitnumber = 0;
    case 2
        orbitnumber = 0;
    case 3
        % continue
    otherwise
        fresult = [];
        error('myApp:argChk', 'Wrong parameters')
end

%% Check odd windowsize

if (windowsize < 4) || (windowsize > 5) 
    fresult = [];
    error('myApp:argChk', 'Only implemented for window sizes 4 and 5, yet')
end
%% Check orbit number
ws1 = windowsize-1; %Window size - 1
wsh = ws1/2;
if abs(orbitnumber) > 0
    fresult=[];
    error('myApp:argChk', 'Only implemented for one orbit; yet')
end

%% Gray or RGB
[s1,s2,nc] = size(image); %Size of the image
gps1 = (1:s1-ws1); %positions for the big window
gps2 = (1:s2-ws1);
switch windowsize
    case 4
        offsets{1}=gps1;
        offsets{2}=gps1+1;
        offsets{3}=gps1+2;
        offsets{4}=gps1+3;
        offsets{5}=gps2+1;
        offsets{6}=gps2+2;
        offsets{7}=gps2+3;
        offsets{8}=gps2;
% Convention for offset indeces: 
% first index at position (1,2,3) second index at position (4,5,6)
%         (1,5)  (1,6)
%
% (2,8)                (2,7)
%
% (3,8)                (3,7)
%
%         (4,5)  (4,6)

    case 5
        offsets{1}=gps1;
        offsets{2}=gps1+1;
        offsets{3}=gps1+3;
        offsets{4}=gps1+4;
        offsets{5}=gps2+1;
        offsets{6}=gps2+3;
        offsets{7}=gps2+4;
        offsets{8}=gps2;
        % Convention for offset indeces: 
% first index at position (1,2,3) second index at position (4,5,6)
%         (1,5)  (1,6)
%
% (2,8)                (2,7)
%
% (3,8)                (3,7)
%
%         (4,5)  (4,6)

    otherwise
        %
end

switch nc
    case 1
        grayim = true;
        fresult = double(zeros(s1,s2,4));
    case 3
        grayim = false;
        fresult = double(zeros(s1,s2,3,4));
    otherwise
        fresult=[];
        error('What?')
        return
end

%% uint8 or double
if isa(image,'uint8')
    ebim = true;
else
    ebim = false;
end

%% Type
egtype = grayim + 2*ebim;

%% Computation of filter results
%% Weights are in columns
% F8 = [...
% 1	1	1	-1	0	1	-1	0;...
% 1	1	-1	1	-1	0	0	1;...
% 1	-1	1	1	-1	0	0	-1;...
% 1	-1	-1	-1	0	-1	-1	0;...
% 1	1	1	-1	0	-1	1	0;...
% 1	1	-1	1	1	0	0	-1;...
% 1	-1	1	1	1	0	0	1;...
% 1	-1	-1	-1	0	1	1	0];

switch egtype
    case 3 %8bit gray
        %%
        newim = double(image);
        fresult(gps1,gps2,1) = ...
            newim(offsets{1},offsets{5})...
            +newim(offsets{1},offsets{6})...
            +newim(offsets{2},offsets{7})...
            +newim(offsets{3},offsets{7})...
            +newim(offsets{4},offsets{6})...
            +newim(offsets{4},offsets{5})...
            +newim(offsets{3},offsets{8})...
            +newim(offsets{2},offsets{8});
        
        fresult(gps1,gps2,2) = ...
            newim(offsets{1},offsets{5})...
            +newim(offsets{1},offsets{6})...
            -newim(offsets{2},offsets{7})...
            -newim(offsets{3},offsets{7})...
            +newim(offsets{4},offsets{6})...
            +newim(offsets{4},offsets{5})...
            -newim(offsets{3},offsets{8})...
            -newim(offsets{2},offsets{8});
        
        fresult(gps1,gps2,3) = ...
            newim(offsets{1},offsets{5})...
            -newim(offsets{1},offsets{6})...
            +newim(offsets{2},offsets{7})...
            -newim(offsets{3},offsets{7})...
            +newim(offsets{4},offsets{6})...
            -newim(offsets{4},offsets{5})...
            +newim(offsets{3},offsets{8})...
            -newim(offsets{2},offsets{8});
        
        fresult(gps1,gps2,4) = ...
            -newim(offsets{1},offsets{5})...
            +newim(offsets{1},offsets{6})...
            +newim(offsets{2},offsets{7})...
            -newim(offsets{3},offsets{7})...
            -newim(offsets{4},offsets{6})...
            +newim(offsets{4},offsets{5})...
            +newim(offsets{3},offsets{8})...
            -newim(offsets{2},offsets{8});
        
        fresult(gps1,gps2,5) = ...            
            -newim(offsets{1},offsets{6})...
            -newim(offsets{2},offsets{7})...
            +newim(offsets{4},offsets{5})...
            +newim(offsets{3},offsets{8});
        
        fresult(gps1,gps2,6) = ...
            newim(offsets{1},offsets{5})...
            -newim(offsets{3},offsets{7})...
            -newim(offsets{4},offsets{6})...
            +newim(offsets{2},offsets{8});
        
        fresult(gps1,gps2,7) = ...
            -newim(offsets{1},offsets{5})...
            -newim(offsets{3},offsets{7})...
            +newim(offsets{4},offsets{6})...
            +newim(offsets{2},offsets{8});
        
              
        fresult(gps1,gps2,8) = ...
            +newim(offsets{1},offsets{6})...
            -newim(offsets{2},offsets{7})...
            -newim(offsets{4},offsets{5})...
            +newim(offsets{3},offsets{8});
        
        %%
    case 2 %8bit RGB
        %%
        newim = double(image);
        fresult(gps1,gps2,:,1) = ...
            newim(offsets{1},offsets{5},:)...
            +newim(offsets{1},offsets{6},:)...
            +newim(offsets{2},offsets{7},:)...
            +newim(offsets{3},offsets{7},:)...
            +newim(offsets{4},offsets{6},:)...
            +newim(offsets{4},offsets{5},:)...
            +newim(offsets{3},offsets{8},:)...
            +newim(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,2) = ...
            newim(offsets{1},offsets{5},:)...
            +newim(offsets{1},offsets{6},:)...
            -newim(offsets{2},offsets{7},:)...
            -newim(offsets{3},offsets{7},:)...
            +newim(offsets{4},offsets{6},:)...
            +newim(offsets{4},offsets{5},:)...
            -newim(offsets{3},offsets{8},:)...
            -newim(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,3) = ...
            newim(offsets{1},offsets{5},:)...
            -newim(offsets{1},offsets{6},:)...
            +newim(offsets{2},offsets{7},:)...
            -newim(offsets{3},offsets{7},:)...
            +newim(offsets{4},offsets{6},:)...
            -newim(offsets{4},offsets{5},:)...
            +newim(offsets{3},offsets{8},:)...
            -newim(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,4) = ...
            -newim(offsets{1},offsets{5},:)...
            +newim(offsets{1},offsets{6},:)...
            +newim(offsets{2},offsets{7},:)...
            -newim(offsets{3},offsets{7},:)...
            -newim(offsets{4},offsets{6},:)...
            +newim(offsets{4},offsets{5},:)...
            +newim(offsets{3},offsets{8},:)...
            -newim(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,5) = ...            
            -newim(offsets{1},offsets{6},:)...
            -newim(offsets{2},offsets{7},:)...
            +newim(offsets{4},offsets{5},:)...
            +newim(offsets{3},offsets{8},:);
        
        fresult(gps1,gps2,:,6) = ...
            newim(offsets{1},offsets{5},:)...
            -newim(offsets{3},offsets{7},:)...
            -newim(offsets{4},offsets{6},:)...
            +newim(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,7) = ...
            -newim(offsets{1},offsets{5},:)...
            -newim(offsets{3},offsets{7},:)...
            +newim(offsets{4},offsets{6},:)...
            +newim(offsets{2},offsets{8},:);
        
              
        fresult(gps1,gps2,:,8) = ...
            +newim(offsets{1},offsets{6},:)...
            -newim(offsets{2},offsets{7},:)...
            -newim(offsets{4},offsets{5},:)...
            +newim(offsets{3},offsets{8},:);
        
        %%
    case 1 %double gray
        %%
        fresult(gps1,gps2,1) = ...
            image(offsets{1},offsets{5})...
            +image(offsets{1},offsets{6})...
            +image(offsets{2},offsets{7})...
            +image(offsets{3},offsets{7})...
            +image(offsets{4},offsets{6})...
            +image(offsets{4},offsets{5})...
            +image(offsets{3},offsets{8})...
            +image(offsets{2},offsets{8});
        
        fresult(gps1,gps2,2) = ...
            image(offsets{1},offsets{5})...
            +image(offsets{1},offsets{6})...
            -image(offsets{2},offsets{7})...
            -image(offsets{3},offsets{7})...
            +image(offsets{4},offsets{6})...
            +image(offsets{4},offsets{5})...
            -image(offsets{3},offsets{8})...
            -image(offsets{2},offsets{8});
        
        fresult(gps1,gps2,3) = ...
            image(offsets{1},offsets{5})...
            -image(offsets{1},offsets{6})...
            +image(offsets{2},offsets{7})...
            -image(offsets{3},offsets{7})...
            +image(offsets{4},offsets{6})...
            -image(offsets{4},offsets{5})...
            +image(offsets{3},offsets{8})...
            -image(offsets{2},offsets{8});
        
        fresult(gps1,gps2,4) = ...
            -image(offsets{1},offsets{5})...
            +image(offsets{1},offsets{6})...
            +image(offsets{2},offsets{7})...
            -image(offsets{3},offsets{7})...
            -image(offsets{4},offsets{6})...
            +image(offsets{4},offsets{5})...
            +image(offsets{3},offsets{8})...
            -image(offsets{2},offsets{8});
        
        fresult(gps1,gps2,5) = ...            
            -image(offsets{1},offsets{6})...
            -image(offsets{2},offsets{7})...
            +image(offsets{4},offsets{5})...
            +image(offsets{3},offsets{8});
        
        fresult(gps1,gps2,6) = ...
            image(offsets{1},offsets{5})...
            -image(offsets{3},offsets{7})...
            -image(offsets{4},offsets{6})...
            +image(offsets{2},offsets{8});
        
        fresult(gps1,gps2,7) = ...
            -image(offsets{1},offsets{5})...
            -image(offsets{3},offsets{7})...
            +image(offsets{4},offsets{6})...
            +image(offsets{2},offsets{8});
        
              
        fresult(gps1,gps2,8) = ...
            +image(offsets{1},offsets{6})...
            -image(offsets{2},offsets{7})...
            -image(offsets{4},offsets{5})...
            +image(offsets{3},offsets{8});
        
        %%
    case 0 %double RGB
        %%
        fresult(gps1,gps2,:,1) = ...
            image(offsets{1},offsets{5},:)...
            +image(offsets{1},offsets{6},:)...
            +image(offsets{2},offsets{7},:)...
            +image(offsets{3},offsets{7},:)...
            +image(offsets{4},offsets{6},:)...
            +image(offsets{4},offsets{5},:)...
            +image(offsets{3},offsets{8},:)...
            +image(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,2) = ...
            image(offsets{1},offsets{5},:)...
            +image(offsets{1},offsets{6},:)...
            -image(offsets{2},offsets{7},:)...
            -image(offsets{3},offsets{7},:)...
            +image(offsets{4},offsets{6},:)...
            +image(offsets{4},offsets{5},:)...
            -image(offsets{3},offsets{8},:)...
            -image(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,3) = ...
            image(offsets{1},offsets{5},:)...
            -image(offsets{1},offsets{6},:)...
            +image(offsets{2},offsets{7},:)...
            -image(offsets{3},offsets{7},:)...
            +image(offsets{4},offsets{6},:)...
            -image(offsets{4},offsets{5},:)...
            +image(offsets{3},offsets{8},:)...
            -image(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,4) = ...
            -image(offsets{1},offsets{5},:)...
            +image(offsets{1},offsets{6},:)...
            +image(offsets{2},offsets{7},:)...
            -image(offsets{3},offsets{7},:)...
            -image(offsets{4},offsets{6},:)...
            +image(offsets{4},offsets{5},:)...
            +image(offsets{3},offsets{8},:)...
            -image(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,5) = ...            
            -image(offsets{1},offsets{6},:)...
            -image(offsets{2},offsets{7},:)...
            +image(offsets{4},offsets{5},:)...
            +image(offsets{3},offsets{8},:);
        
        fresult(gps1,gps2,:,6) = ...
            image(offsets{1},offsets{5},:)...
            -image(offsets{3},offsets{7},:)...
            -image(offsets{4},offsets{6},:)...
            +image(offsets{2},offsets{8},:);
        
        fresult(gps1,gps2,:,7) = ...
            -image(offsets{1},offsets{5},:)...
            -image(offsets{3},offsets{7},:)...
            +image(offsets{4},offsets{6},:)...
            +image(offsets{2},offsets{8},:);
        
              
        fresult(gps1,gps2,:,8) = ...
            +image(offsets{1},offsets{6},:)...
            -image(offsets{2},offsets{7},:)...
            -image(offsets{4},offsets{5},:)...
            +image(offsets{3},offsets{8},:);
        %%
    otherwise
        fresult =[];
        error(' ');
end
if grayim
    fresult(:,:,1:4) = fresult(:,:,1:4)/sqrt(8);
    fresult(:,:,5:8) = fresult(:,:,5:8)/2;
else
    fresult(:,:,:,1:4) = fresult(:,:,:,1:4)/sqrt(8);
    fresult(:,:,:,5:8) = fresult(:,:,:,5:8)/2;
end
return
end



