

function FG=grad_func_eval(sigma,kappa,type)
%set "type" parameter to 1 for Eigen-orientation, 0 for Variance or
%9 for Fisher trace, 8 for Entropy
    Euler=0.577215664901532;

    
if type==1
    % % Eigen orientation
    xi = (6 *(-1 + Euler)^2 + pi^2);
    eta=(6 * (-1 + Euler)^2 - pi^2);
    
    FG(1) = (6 *(-1 + Euler).* kappa^2 *(6* kappa.^4 + sigma.^2 *xi))/( 36* kappa.^8 + 12.*sigma.^2.*kappa^4.*eta + sigma.^4.*xi.^2);  %wrt scale
    FG(2)= (12* (-1 + Euler).* sigma.* kappa.* (-6* kappa.^4 - sigma.^2.*xi))./(36*kappa.^8 + 12 *sigma.^2.* kappa.^4.* eta + sigma^4.*xi^2); %wrt shape 
    
elseif type==0
    % Weibull variance
    FG(1)=-2*sigma.*(-gamma((1 + kappa)./kappa).^2 + gamma((2 + kappa)./kappa));  %wrt scale
    FG(2)=((2*sigma.^2)./(kappa.^4)).*(-gamma(1./kappa).^2.*psi(1 + 1./kappa) + 2*kappa.*gamma(2./kappa).*psi((2 + kappa)./kappa)); %wrt shape 
    
elseif type==9
    % Fisher trace
      FG(1)=((2*kappa.^2)./sigma.^3);  %wrt scale
    FG(2)=((6+6*(-2 + Euler).* Euler + pi^2 - (6 *kappa.^4)./sigma.^2)./(3 *kappa.^3));     %wrt shape 
  
    
elseif type==8
    %Weibull entropy
    FG(1)= (-1./kappa + Euler./(kappa.^2));  %wrt scale
    FG(2)=  1./sigma; %wrt shape 
    
end

end
