function fres = gedge5x5( grayimage )
%g5x5: fres = gedge5x5( grayimage )
%   Filter a Ggray  image with a 5x5 edge filters
%

%% Filter the image with the original filters (inner and two corner, two axes)

ifi = idfilter(grayimage,5,0);
cfi1 = cdfilter(grayimage,5,0);
cfi2 = cdfilter(grayimage,5,1);
afi1 = adfilter(grayimage,5,0);
afi2 = adfilter(grayimage,5,1);

%% magnitude corner filters

magc2 = squeeze(...
    cfi2(1:end-4,1:end-4,2).^2+...
    cfi2(1:end-4,1:end-4,3).^2); % outer corner filter
magc1 = squeeze(...
    cfi1(1:end-4,1:end-4,2).^2+...
    cfi1(1:end-4,1:end-4,3).^2); % inner corner filter



%% axes

maga2 = squeeze(...
    afi2(1:end-4,1:end-4,3).^2+...
    afi2(1:end-4,1:end-4,4).^2); % outer axis filter
maga1 = squeeze(...
    afi1(1:end-4,1:end-4,3).^2+...
    afi1(1:end-4,1:end-4,4).^2); % inner axis filter

%% inner
%% axes

magi2 = squeeze(...
    ifi(1:end-4,1:end-4,5).^2+...
    ifi(1:end-4,1:end-4,6).^2); % first inner  filter
magi1 = squeeze(...
    ifi(1:end-4,1:end-4,7).^2+...
    ifi(1:end-4,1:end-4,8).^2); % second inner  filter

%%
fres = cat(2,magc1(:),magc2(:),maga1(:),maga2(:),magi1(:),magi2(:));
return
end

