
function F = func_eval(sigma,kappa,type)
%set "type" parameter to 1 for Eigen-orientation, 0 for Variance or
%9 for Fisher trace, 8 for Entropy
    Euler=0.577215664901532;

if type==1
    
    %% Eigen orientation

    omega= -24 *pi^2 *sigma^2* kappa^4 + ((6 *(-1 + Euler)^2 + pi^2) *sigma^2 +  6 *kappa^4)^2 ;
    xi = (6 *(-1 + Euler)^2 + pi^2);
    F= -atan2(-6*kappa.^4 + sigma.^2.*xi - sqrt(omega),-12* (-1 + Euler).* sigma.*kappa^2);
    
elseif type==0
    %% Weibull variance
    F= -sigma.^2.*(gamma((kappa+2)./kappa)-gamma((kappa+1)./kappa).^2);
    
elseif type==9
    %% Weibull Fisher trace
    I=W2Fisher(sigma,kappa);
    
    F=-trace(I);
    
elseif type==8
    %Weibull entropy
    F=-(Euler*(1-1./kappa)+log(sigma./kappa)+1);
    
end

end
