function fresult = cdfilter(image,windowsize,cornernumber)
%CDFILTER: fresult = cdfilter(image,windowsize,cornernumber)
%   Dihedral filters for the corner points
%
% Version 1.0
% Reiner Lenz
% 26. Oct. 2011

%% nargin = 1,2,3

switch nargin
    case 1
        windowsize = 2;
        cornernumber = 0;
    case 2
        cornernumber = 0;
    case 3
        % continue
    otherwise
        fresult = [];
        error('myApp:argChk', 'Wrong parameters')
end

%% Check window size


if (windowsize < 1)
    fresult=[];
    error('myApp:argChk','Wrong window size')
end

%% Check corner number

wsh = floor(windowsize/2);
if (cornernumber < 0) || (cornernumber > wsh-1)
    fresult=[];
    error('myApp:argChk','Wrong corner number')
end

%% Gray or RGB
[s1,s2,nc] = size(image); %Size of the image
ws1 = windowsize-1; %Window size -1
gps1 = (1:s1-ws1); %positions for the big window
gps2 = (1:s2-ws1);
offsets{1}=gps1+cornernumber;
offsets{2}=gps1-cornernumber+ws1;
offsets{3}=gps2+cornernumber;
offsets{4}=gps2-cornernumber+ws1;

% Convention for offset indeces: 
% first index at position (1,2) second index at position (3,4)
%  (1,3)   ... (2,3)
%
%  (1,4)   ... (2,4)

switch nc
    case 1
        grayim = true;
        fresult = double(zeros(s1,s2,4));
    case 3
        grayim = false;
        fresult = double(zeros(s1,s2,3,4));
    otherwise
        fresult=[];
        error('myApp:argChk', 'What?')
end

%% uint8 or double
if isa(image,'uint8')
    ebim = true;
else
    ebim = false;
end

%% Type
egtype = grayim + 2*ebim;

%%
switch egtype
    case 3 %8bit gray
        %%
        newim = double(image);
        fresult(gps1,gps2,1) = ...
            newim(offsets{1},offsets{3}) +...
            newim(offsets{2},offsets{3})+...
            newim(offsets{1},offsets{4})+...
            newim(offsets{2},offsets{4});
        fresult(gps1,gps2,2) = ...
            newim(offsets{1},offsets{3}) -...
            newim(offsets{2},offsets{3})+...
            newim(offsets{1},offsets{4})-...
            newim(offsets{2},offsets{4});
        fresult(gps1,gps2,3) = ...
            newim(offsets{1},offsets{3}) +...
            newim(offsets{2},offsets{3})-...
            newim(offsets{1},offsets{4})-...
            newim(offsets{2},offsets{4});
        fresult(gps1,gps2,4) = ...
            newim(offsets{1},offsets{3}) -...
            newim(offsets{2},offsets{3})-...
            newim(offsets{1},offsets{4})+...
            newim(offsets{2},offsets{4});
        %%
    case 2 %8bit RGB
        %%
        newim = double(image);
        fresult(gps1,gps2,:,1) = ...
            newim(offsets{1},offsets{3},:) +...
            newim(offsets{2},offsets{3},:)+...
            newim(offsets{1},offsets{4},:)+...
            newim(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,2) = ...
            newim(offsets{1},offsets{3},:) -...
            newim(offsets{2},offsets{3},:)+...
            newim(offsets{1},offsets{4},:)-...
            newim(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,3) = ...
            newim(offsets{1},offsets{3},:) +...
            newim(offsets{2},offsets{3},:)-...
            newim(offsets{1},offsets{4},:)-...
            newim(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,4) = ...
            newim(offsets{1},offsets{3},:) -...
            newim(offsets{2},offsets{3},:)-...
            newim(offsets{1},offsets{4},:)+...
            newim(offsets{2},offsets{4},:);
        %%
    case 1 %double gray
        %%
        fresult(gps1,gps2,1) = ...
            image(offsets{1},offsets{3}) +...
            image(offsets{2},offsets{3})+...
            image(offsets{1},offsets{4})+...
            image(offsets{2},offsets{4});
        fresult(gps1,gps2,2) = ...
            image(offsets{1},offsets{3}) -...
            image(offsets{2},offsets{3})+...
            image(offsets{1},offsets{4})-...
            image(offsets{2},offsets{4});
        fresult(gps1,gps2,3) = ...
            image(offsets{1},offsets{3}) +...
            image(offsets{2},offsets{3})-...
            image(offsets{1},offsets{4})-...
            image(offsets{2},offsets{4});
        fresult(gps1,gps2,4) = ...
            image(offsets{1},offsets{3}) -...
            image(offsets{2},offsets{3})-...
            image(offsets{1},offsets{4})+...
            image(offsets{2},offsets{4});
        %%
    case 0 %double RGB
        %%
        fresult(gps1,gps2,:,1) = ...
            image(offsets{1},offsets{3},:) +...
            image(offsets{2},offsets{3},:)+...
            image(offsets{1},offsets{4},:)+...
            image(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,2) = ...
            image(offsets{1},offsets{3},:) -...
            image(offsets{2},offsets{3},:)+...
            image(offsets{1},offsets{4},:)-...
            image(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,3) = ...
            image(offsets{1},offsets{3},:) +...
            image(offsets{2},offsets{3},:)-...
            image(offsets{1},offsets{4},:)-...
            image(offsets{2},offsets{4},:);
        fresult(gps1,gps2,:,4) = ...
            image(offsets{1},offsets{3},:) -...
            image(offsets{2},offsets{3},:)-...
            image(offsets{1},offsets{4},:)+...
            image(offsets{2},offsets{4},:);
        %%
    otherwise
        fresult =[];
        error('myApp:argChk', ' This will never happen');
end
fresult = fresult/2;
return
end



