function fresult = adfilter(image,windowsize,axisnumber)
%ADFILTER: fresult = adfilter(image,windowsize,axisnumber)
%   Dihedral filters for the axes points
%
% Version 1.0
% Reiner Lenz
% 26. Oct. 2011

%% nargin = 1,2,3

switch nargin
    case 1
        windowsize = 3;
        axisnumber = 0;
    case 2
        axisnumber = 0;
    case 3
        % continue
    otherwise
        fresult = [];
        error('myApp:argChk', 'Wrong parameters')
end

%% Check odd windowsize

if (windowsize < 1)
    fresult=[];
    error('myApp:argChk','Wrong window size')
end

if rem(windowsize,2) < 1
    fresult = [];
    error('myApp:argChk', 'Only odd window sizes for axes')
end

%% Check axis number
ws1 = windowsize-1; %Window size - 1
wsh = ws1/2;
if (axisnumber < 0) || (axisnumber > wsh-1)
    fresult=[];
    error('myApp:argChk', 'Wrong axis number')
end

%% Gray or RGB
[s1,s2,nc] = size(image); %Size of the image
gps1 = (1:s1-ws1); %positions for the big window
gps2 = (1:s2-ws1);
offsets{1}=gps1+wsh;
offsets{2}=gps1+axisnumber;
offsets{3}=gps1+ws1-axisnumber;
offsets{4}=gps2+axisnumber;
offsets{5}=gps2+wsh;
offsets{6}=gps2+ws1-axisnumber;
% Convention for offset indeces: 
% first index at position (1,2,3) second index at position (4,5,6)
%         (1,4)   
% (2,5)            (3,5)
%
%         (1,6)
switch nc
    case 1
        grayim = true;
        fresult = double(zeros(s1,s2,4));
    case 3
        grayim = false;
        fresult = double(zeros(s1,s2,3,4));
    otherwise
        fresult=[];
        error('myApp:argChk', 'What?')
end

%% uint8 or double
if isa(image,'uint8')
    ebim = true;
else
    ebim = false;
end

%% Type
egtype = grayim + 2*ebim;

%% Computation of filter results
switch egtype
    case 3 %8bit gray
        %%
        newim = double(image);
        fresult(gps1,gps2,1) = ...
            newim(offsets{1},offsets{4}) +...
            newim(offsets{3},offsets{5})+...
            newim(offsets{1},offsets{6})+...
            newim(offsets{2},offsets{5});
        fresult(gps1,gps2,2) = ...
            newim(offsets{1},offsets{4}) -...
            newim(offsets{3},offsets{5})+...
            newim(offsets{1},offsets{6})-...
            newim(offsets{2},offsets{5});
        fresult(gps1,gps2,3) = ...
            newim(offsets{1},offsets{4}) +...
            newim(offsets{3},offsets{5})-...
            newim(offsets{1},offsets{6})-...
            newim(offsets{2},offsets{5});
        fresult(gps1,gps2,4) = ...
            newim(offsets{1},offsets{4}) -...
            newim(offsets{3},offsets{5})-...
            newim(offsets{1},offsets{6})+...
            newim(offsets{2},offsets{5});
        %%
    case 2 %8bit RGB
        %%
        newim = double(image);
        fresult(gps1,gps2,:,1) = ...
            newim(offsets{1},offsets{4},:) +...
            newim(offsets{3},offsets{5},:)+...
            newim(offsets{1},offsets{6},:)+...
            newim(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,2) = ...
            newim(offsets{1},offsets{4},:) -...
            newim(offsets{3},offsets{5},:)+...
            newim(offsets{1},offsets{6},:)-...
            newim(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,3) = ...
            newim(offsets{1},offsets{4},:) +...
            newim(offsets{3},offsets{5},:)-...
            newim(offsets{1},offsets{6},:)-...
            newim(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,4) = ...
            newim(offsets{1},offsets{4},:) -...
            newim(offsets{3},offsets{5},:)-...
            newim(offsets{1},offsets{6},:)+...
            newim(offsets{2},offsets{5},:);
        %%
    case 1 %double gray
        %%
        fresult(gps1,gps2,1) = ...
            image(offsets{1},offsets{4}) +...
            image(offsets{3},offsets{5})+...
            image(offsets{1},offsets{6})+...
            image(offsets{2},offsets{5});
        fresult(gps1,gps2,2) = ...
            image(offsets{1},offsets{4}) -...
            image(offsets{3},offsets{5})+...
            image(offsets{1},offsets{6})-...
            image(offsets{2},offsets{5});
        fresult(gps1,gps2,3) = ...
            image(offsets{1},offsets{4}) +...
            image(offsets{3},offsets{5})-...
            image(offsets{1},offsets{6})-...
            image(offsets{2},offsets{5});
        fresult(gps1,gps2,4) = ...
            image(offsets{1},offsets{4}) -...
            image(offsets{3},offsets{5})-...
            image(offsets{1},offsets{6})+...
            image(offsets{2},offsets{5});
        %%
    case 0 %double RGB
        %%
        fresult(gps1,gps2,:,1) = ...
            image(offsets{1},offsets{4},:) +...
            image(offsets{3},offsets{5},:)+...
            image(offsets{1},offsets{6},:)+...
            image(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,2) = ...
            image(offsets{1},offsets{4},:) -...
            image(offsets{3},offsets{5},:)+...
            image(offsets{1},offsets{6},:)-...
            image(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,3) = ...
            image(offsets{1},offsets{4},:) +...
            image(offsets{3},offsets{5},:)-...
            image(offsets{1},offsets{6},:)-...
            image(offsets{2},offsets{5},:);
        fresult(gps1,gps2,:,4) = ...
            image(offsets{1},offsets{4},:) -...
            image(offsets{3},offsets{5},:)-...
            image(offsets{1},offsets{6},:)+...
            image(offsets{2},offsets{5},:);
        %%
    otherwise
        fresult =[];
        error('myApp:argChk', ' This will never happen');
end
fresult = fresult/2;
return
end



