

function [F,sigma,kappa,t_abs]=SharpnessFunction(t,path,lensMIN,lensMAX,type,init,t_abs_curr)
%set "type" parameter to 1 for Weibull Eigen-orientation 0 for Weibull Variance, 2 for image entropy, 3 for image variance, 4 for Tennegrad
%9 for Fisher trace
t_abs=t_abs_curr;
if t>=lensMIN && t<=lensMAX %manual bound checking for unbounded optimization methods

    %grab a new image from the camera
    patch_out=SampleImage(t,path,lensMIN,lensMAX); %from lookup table
%     [patch_out,t_abs]=SampleImage_from_Camera(t,t_abs_curr); %from the actual Canon camera
    
    if type==1 || type==0  || type==9 
    %map from camera lens position to Weibull space
    [sigma,kappa]=t_to_Weib_map(patch_out,init);
    
    
    %map from Weibull space to Sharpness Function space
    F = func_eval(sigma,kappa,type);

    elseif type==2
       F= sentropy(double(patch_out(:)'));
       sigma=0;
       kappa=0;
       
    elseif type==3
       F= -var(double(patch_out(:)'));
       sigma=0;
       kappa=0;
       
    elseif type==4
       F= TenenbaumGradient(double(patch_out(:)'));
       sigma=0;
       kappa=0;
      
    end
    
    
else
    F=1e10;
    sigma=0;
    kappa=0;
end


end
