
function patch_out=SampleImage(t,path,lensMIN,lensMAX)
%get an image sample at lens position t
%use pre-computed lookup table
DR=dir([path,'/*.jpg']);
sz=size(DR,1);

dvecs=linspace(lensMIN,lensMAX,sz); %use manual ds if none are available
lensMinimumStepsize= dvecs(2)-dvecs(1); %automatically determine this from the density of the focus stack

indx=find(dvecs>t+lensMinimumStepsize);
if isempty(indx)
    indx=sz;
end


im=imread([path,'/',DR(indx(1)-1).name]);

if ndims(im)>2
  im=rgb2gray(im);
end

im=imresize(im,0.5);

patchsize=200;

[height,width,~]=size(im);

cx=floor(width/2)-0;
cy=floor(height/2)+0;

patch_out=im(cx-patchsize/2:cx+patchsize/2,cy-patchsize/2:cy+patchsize/2,:); %from the center




end
