function s=Rao_dist(p1,p2,type)


%2 parameter Weibull, Frechet and Gumbel Rao distance
%between two points p1=(scale1,shape1),p2=(scale2,shape2) or for Gumbel p=(location,shape). 
%type=['Weibull','Frechet','Gumbel']

alpha=1+psi(1);
beta=pi/sqrt(6);


if strcmp(type,'Weibull')
    nom = (log(p2(1)/p1(1))-alpha*(p2(2)-p1(2))/(p1(2)*p2(2)))^2 + beta^2*(p2(2)-p1(2))^2/(p2(2)^2*p1(2)^2);
    denom =  (log(p2(1)/p1(1))-alpha*(p2(2)-p1(2))/(p1(2)*p2(2)))^2 + beta^2*(p2(2)+p1(2))^2/(p2(2)^2*p1(2)^2);

    
elseif strcmp(type,'Frechet')
    nom = (log(p2(1)/p1(1))+alpha*(p2(2)-p2(1))/(p1(2)*p2(2)))^2 + beta^2*(p2(2)-p1(2))^2/(p1(2)^2*p2(2)^2);
    denom = (log(p2(1)/p1(1))+alpha*(p2(2)-p2(1))/(p1(2)*p2(2)))^2 + beta^2*(p2(2)+p1(2))^2/(p1(2)^2*p2(2)^2);

    
else
    
    nom = ((p2(1)-p1(1)) - alpha*(p2(2)-p1(2)))^2 + beta^2*(p2(2)-p1(2))^2;
    denom = ((p2(1)-p1(1)) - alpha*(p2(2)-p1(2)))^2 + beta^2*(p2(2)+p1(2))^2;
   
end

 delta12=  sqrt(nom/denom);
    
 s= 2*pi/sqrt(6) * atanh(delta12);