function paramEsts = NewWeibfit_MLE_direct(data,alpha,cens,freq,opts,init)
% Starting values are needed:
    e=1e-18;
     xi=e; %zero mean
 

if init(1)>0 && init(2)>0
    
    sigma=init(2);
    alpha=init(1);
else
    p=wblfit(data); %use a 2 parameter model
    sigma=p(2); %shape
    alpha= p(1); %scale
    
end

options = statset('FunValCheck','off','MaxFunEvals',2000,'MaxIter',1000);
if(min(data)-e) > 0
    xx = min(data)-e;
else
    xx = min(data)/2;
end
if xi >xx
    xi = xx/2;
end
paramEsts = mle(data, 'pdf',@NewWeibpdf, 'cdf',@NewWeibcdf, 'start',[xi,alpha,sigma],'lowerbound',[0,0,0],'upperbound',[xx,Inf,Inf],'options',options);


