% Spectrum data
load spm.mat               
subplot(2,2,1), plot(f(:,1), f(:,2), '-b');
title('a) Spectrum'); 
xlabel('E [keV]'); ylabel('N(E)');
axis([5 50 0 1200]); grid;

% Material data
load ../materials/plexi.mat 
dens = 1.19;	            % Plexiglass density
pmat = 100 * dens * (f(:,2) + f(:,3) + f(:,4));
subplot(2,2,2), plot(1000*f(:,1), pmat, '-b');
title('b) Attenuation coeff'); 
xlabel('E [keV]'); ylabel('\mu(E) [1/m]');
axis([5 50 0 100]); grid;

% Loop over phantoms with different thickness and 
% compute the relative attenuation
g1 = zeros(1,10);
for i=1:10
  p = ['phantom = phm' num2str(i) '.txt'];
  y = take(p);
  g1(i) = log(y(1)/y(33));
end
g0 = zeros(1,10);
for i=1:10
  p = ['phantom = phm' num2str(i) '.txt'];
  y = take(p,'mono=30');
  g0(i) = log(y(1)/y(33));
end
subplot(2,2,3), plot(1:10, g1/g1(1), '--r', 1:10, g0/g0(1), '-b')
title('c) relative attenuation');
xlabel('d [cm]'); ylabel('relative attenuation');
axis([1 10 1 10]); grid;