g = take('mono=30');

rec = 0.6;          % reconstructed image size

[N,R,M] = size(g);  % N = nr of pixels per projection
                    % R = nr of rows
                    % M = nr of projections

x = (-(N-1)/2:(N-1)/2);	         % detector axis
a = (0:M-1)*360/M;		 % projection angles

xvec = (-(N-1)/2:(N-1)/2)*rec/N; % image axis

geo = [0.7 0.4571*2/64];         % fanbeam geometry
firstang = 0;

g1 = zeros(N,M);
g1(:,:) = g(:,1,:);
g1 = log(max(max(g1))) - log(g1); % take the logarithm

fhat = fanFB(g1, geo, rec, firstang);      % fanbeam reconstr

figure(1);
subplot(2,2,1), imagesc(a, x, g1);
colorbar;
title('a) fanbeam proj')

subplot(2,2,2), imagesc(xvec, xvec, fhat');
colorbar;
title('b) reconstruction')
axis image;

subplot(2,2,3), plot(xvec, fhat(:,32), '-r', ...
		     xvec, fhat(32,:), '--b');
title('c) recon cross-sec')
xlabel('x [m], y [m]');
ylabel('\mu [m^{-1}]');
axis([-rec/2 rec/2 -5 40]);



