function f = fanFB(g, geo, rec, firstang)
%
% f = fanFB(g, geo, rec, firstang) 
%
% geo(1):   distance source <-> origo
% geo(2):   angle between rays
% rec:      image x size
% firstang: angle for first projection [rad]

if nargin ~= 4
  fprintf('The number of arguments must be 4!\n');
  return;
end

[M,N] = size(g);   % M = nr of pixels per projection, 
                   % N = nr of projections			

D = geo(1);
dalfa = geo(2);

if N == 1	   % special case for rot. sym. obj.
  N = 2*M;
  g = g*ones(1,N);
end

Sx = rec;
Sy = Sx;
m0 = M;
n0 = M;
startx = -Sx/2 + 0.5*Sx/M;
starty = startx;

% projection angles
dbeta = 2*pi/N;
beta = 0+firstang:dbeta:2*pi+firstang-dbeta;


% detector angles
alfa = dalfa*(-(M-1)/2:(M-1)/2)';

% preweight the projections with D * cos(alfa)
g = g.*(D*cos(alfa)*ones(1,N));

% rampfilter the projections 
q = ramp(g,dalfa);

% the grid for the reconstructed image
dx = Sx/m0;
dy = Sy/n0;

[X,Y] = meshgrid(startx:dx:startx+(m0-1)*dx, starty:dy:starty+(n0-1)*dy);

f = zeros(size(X));

% weighted backprojection
for i=1:N
   x0 = D*sin(beta(i));
   y0 = D*cos(beta(i));
   L2 = (x0-X).^2 + (y0+Y).^2;
   gamma = -adjust(atan2(x0-X,y0+Y) - beta(i));
   f = f + interp2(ones(M,1)*(1:N), alfa*ones(1,N), q, i*ones(m0,m0), gamma)./L2;
end

% find NaN:s and replace them with 0
loc = find(isnan(f)==1);
f(loc) = 0;

f = f*dbeta*dalfa;
   
function y = adjust(x)
y=x;
y(find(x>=pi)) = y(find(x>=pi)) - 2*pi;
y(find(x<-pi)) = y(find(x<-pi)) + 2*pi;


